<?php
/*--------------------------------------------------------------
   ResizeWidget.php 2021-06-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Action;

use Exception;
use Gambio\Admin\Modules\Statistics\App\Overview\SchemaValidator;
use Gambio\Admin\Modules\Statistics\App\Overview\Service;
use Gambio\Core\Application\Http\AbstractAction;
use Gambio\Core\Application\Http\Request;
use Gambio\Core\Application\Http\Response;

/**
 * @codeCoverageIgnore
 */
class ResizeWidget extends AbstractAction
{
    private const SCHEMA_ID = "https://gambio.com/schema/ResizeWidgetRequestBody.json";
    
    /**
     * @var Service
     */
    private $service;
    
    /**
     * @var SchemaValidator
     */
    private $validator;
    
    
    /**
     * Constructor.
     */
    public function __construct(Service $service, SchemaValidator $validator)
    {
        $this->service   = $service;
        $this->validator = $validator;
    }
    
    
    /**
     * @inheritDoc
     */
    public function handle(Request $request, Response $response): Response
    {
        $data = json_decode($request->getBody()->getContents());
        
        try {
            $this->validator->validate(self::SCHEMA_ID, $data);
            $this->service->resizeWidget((int)$request->getAttribute('id'), $data->width, $data->height);
        } catch (Exception $exception) {
            return $response->withStatus(400)->write($exception->getMessage());
        }
        
        return $response->withStatus(200);
    }
}